﻿IF OBJECT_ID(N'[dbo].[FK_PrincipalGF_Accolade]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Accolade] DROP CONSTRAINT [FK_PrincipalGF_Accolade];
GO
IF OBJECT_ID(N'[dbo].[FK_PrincipalGF_AssignedAchievement]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_AssignedAchievement] DROP CONSTRAINT [FK_PrincipalGF_AssignedAchievement];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_QuizGF_Field]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Field] DROP CONSTRAINT [FK_GF_QuizGF_Field];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_FieldGF_Option]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Option] DROP CONSTRAINT [FK_GF_FieldGF_Option];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_ResponseGF_ResponseField]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_ResponseField] DROP CONSTRAINT [FK_GF_ResponseGF_ResponseField];
GO
IF OBJECT_ID(N'[dbo].[FK_PrincipalGF_Response]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Response] DROP CONSTRAINT [FK_PrincipalGF_Response];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentGF_TournamentMember]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_TournamentMember] DROP CONSTRAINT [FK_GF_TournamentGF_TournamentMember];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentGF_SpecialBet]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_SpecialBet] DROP CONSTRAINT [FK_GF_TournamentGF_SpecialBet];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_SpecialBetGF_SpecialbetOption]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_SpecialbetOption] DROP CONSTRAINT [FK_GF_SpecialBetGF_SpecialbetOption];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentGF_Game]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Game] DROP CONSTRAINT [FK_GF_TournamentGF_Game];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentGF_Placedbet]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Placedbet] DROP CONSTRAINT [FK_GF_TournamentGF_Placedbet];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentGF_TournamentUser]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_TournamentUser] DROP CONSTRAINT [FK_GF_TournamentGF_TournamentUser];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_QuizGF_QuizAdmin]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_QuizUser] DROP CONSTRAINT [FK_GF_QuizGF_QuizAdmin];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_QuizGF_QuizAction]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_QuizAction] DROP CONSTRAINT [FK_GF_QuizGF_QuizAction];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_AchievementGF_QuizAction]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_QuizAction] DROP CONSTRAINT [FK_GF_AchievementGF_QuizAction];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentGF_TournamentAction]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_TournamentAction] DROP CONSTRAINT [FK_GF_TournamentGF_TournamentAction];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_AchievementGF_TournamentAction]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_TournamentAction] DROP CONSTRAINT [FK_GF_AchievementGF_TournamentAction];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_QuizGF_Response]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Response] DROP CONSTRAINT [FK_GF_QuizGF_Response];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentUserPrincipal]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_TournamentUser] DROP CONSTRAINT [FK_GF_TournamentUserPrincipal];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_TournamentUserGF_BetHisory]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_BetHistory] DROP CONSTRAINT [FK_GF_TournamentUserGF_BetHisory];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_AchievementGF_SkillLevel]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_SkillLevel] DROP CONSTRAINT [FK_GF_AchievementGF_SkillLevel];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_AchievementGF_AssignedAchievement]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_AssignedAchievement] DROP CONSTRAINT [FK_GF_AchievementGF_AssignedAchievement];
GO
IF OBJECT_ID(N'[dbo].[FK_GF_SkillLevelGF_AssignedAchievement]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_AssignedAchievement] DROP CONSTRAINT [FK_GF_SkillLevelGF_AssignedAchievement];
GO
IF OBJECT_ID(N'[dbo].[FK_PrincipalGF_Accolade1]', 'F') IS NOT NULL
    ALTER TABLE [dbo].[GF_Accolade] DROP CONSTRAINT [FK_PrincipalGF_Accolade1];
GO




IF OBJECT_ID(N'[dbo].[GF_Achievement]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Achievement];
GO
IF OBJECT_ID(N'[dbo].[GF_AssignedAchievement]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_AssignedAchievement];
GO
IF OBJECT_ID(N'[dbo].[GF_Accolade]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Accolade];
GO
IF OBJECT_ID(N'[dbo].[GF_SkillLevel]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_SkillLevel];
GO
IF OBJECT_ID(N'[dbo].[GF_Quiz]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Quiz];
GO
IF OBJECT_ID(N'[dbo].[GF_Field]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Field];
GO
IF OBJECT_ID(N'[dbo].[GF_Option]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Option];
GO
IF OBJECT_ID(N'[dbo].[GF_Response]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Response];
GO
IF OBJECT_ID(N'[dbo].[GF_ResponseField]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_ResponseField];
GO
IF OBJECT_ID(N'[dbo].[GF_QuizUser]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_QuizUser];
GO
IF OBJECT_ID(N'[dbo].[GF_Tournament]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Tournament];
GO
IF OBJECT_ID(N'[dbo].[GF_TournamentMember]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_TournamentMember];
GO
IF OBJECT_ID(N'[dbo].[GF_SpecialBet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_SpecialBet];
GO
IF OBJECT_ID(N'[dbo].[GF_SpecialbetOption]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_SpecialbetOption];
GO
IF OBJECT_ID(N'[dbo].[GF_Game]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Game];
GO
IF OBJECT_ID(N'[dbo].[GF_ExternalTeam]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_ExternalTeam];
GO
IF OBJECT_ID(N'[dbo].[GF_Placedbet]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_Placedbet];
GO
IF OBJECT_ID(N'[dbo].[GF_TournamentUser]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_TournamentUser];
GO
IF OBJECT_ID(N'[dbo].[GF_InteralTeam]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_InteralTeam];
GO
IF OBJECT_ID(N'[dbo].[GF_QuizAction]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_QuizAction];
GO
IF OBJECT_ID(N'[dbo].[GF_TournamentAction]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_TournamentAction];
GO
IF OBJECT_ID(N'[dbo].[GF_BetHistory]', 'U') IS NOT NULL
    DROP TABLE [dbo].[GF_BetHistory];
GO



-- Creating table 'GF_Achievement'
CREATE TABLE [dbo].[GF_Achievement] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Picture] nvarchar(max)  NOT NULL,
    [Description] nvarchar(max)  NOT NULL,
    [Type] int  NOT NULL,
    [ExpireType] int  NOT NULL,
    [Period] nvarchar(max)  NULL,
    [Number] int  NULL,
    [Points] int  NULL
);
GO

-- Creating table 'GF_AssignedAchievement'
CREATE TABLE [dbo].[GF_AssignedAchievement] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [ActionDate] datetime  NULL,
    [Type] nvarchar(max)  NULL,
    [TypeId] int  NULL,
    [Metadata] nvarchar(max)  NULL,
    [CurrentProcent] float  NULL,
    [Principal_PrincipalID] int  NOT NULL,
    [GF_Achievement_Id] int  NOT NULL,
    [GF_SkillLevel_Id] int  NULL
);
GO

-- Creating table 'GF_Accolade'
CREATE TABLE [dbo].[GF_Accolade] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Date] datetime  NOT NULL,
    [Text] nvarchar(max)  NOT NULL,
    [Author_PrincipalID] int  NOT NULL,
    [Reciever_PrincipalID] int  NOT NULL
);
GO

-- Creating table 'GF_SkillLevel'
CREATE TABLE [dbo].[GF_SkillLevel] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(max)  NOT NULL,
    [RequiredProcent] int  NOT NULL,
    [GF_Achievement_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Quiz'
CREATE TABLE [dbo].[GF_Quiz] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [EndDate] datetime  NOT NULL,
    [CanEdit] bit  NOT NULL,
    [QuizType] int  NOT NULL,
    [Logo] nvarchar(max)  NULL,
    [WinnerAvaliable] bit  NOT NULL,
    [MaxPoint] int  NULL,
    [Description] nvarchar(max)  NULL,
    [UseSocial] bit  NULL,
    [ShowOverview] bit  NULL,
    [StartDate] datetime  NULL,
    [Ended] bit  NULL,
    [Winner] nvarchar(max)  NULL,
	[Anonymous] bit  NOT NULL,
    [SeeResultBeforeAnswer] bit  NOT NULL
);
GO

-- Creating table 'GF_Field'
CREATE TABLE [dbo].[GF_Field] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [Required] bit  NOT NULL,
    [CorrectOption] int  NOT NULL,
    [Point] int  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Option'
CREATE TABLE [dbo].[GF_Option] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Value] int  NOT NULL,
    [GF_Field_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Response'
CREATE TABLE [dbo].[GF_Response] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Score] int  NOT NULL,
    [AllCorrect] bit  NOT NULL,
    [Principal_PrincipalID] int  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL
);
GO

-- Creating table 'GF_ResponseField'
CREATE TABLE [dbo].[GF_ResponseField] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Value] nvarchar(max)  NOT NULL,
    [FieldId] int  NOT NULL,
    [GF_Response_Id] int  NOT NULL
);
GO

-- Creating table 'GF_QuizUser'
CREATE TABLE [dbo].[GF_QuizUser] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [UniqueId] nvarchar(max)  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [RoleType] int  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Tournament'
CREATE TABLE [dbo].[GF_Tournament] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Amount] float  NOT NULL,
    [EndDate] datetime  NOT NULL,
    [Logo] nvarchar(max)  NULL,
    [Description] nvarchar(max)  NULL,
    [Ended] bit  NULL,
    [StartDate] datetime  NULL,
    [ExternalTournamentComplexType_ProviderLeague] int  NULL,
    [ExternalTournamentComplexType_ProviderSport] int  NULL,
    [ExternalTournamentComplexType_ProviderLastTimestamp] bigint  NULL,
    [Type] int  NOT NULL
);
GO

-- Creating table 'GF_TournamentMember'
CREATE TABLE [dbo].[GF_TournamentMember] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Type] nvarchar(max)  NOT NULL,
    [UniqueId] nvarchar(max)  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [RoleType] int  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_SpecialBet'
CREATE TABLE [dbo].[GF_SpecialBet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [StartDate] datetime  NOT NULL,
    [CorrectAnswer] int  NOT NULL,
    [Finished] bit  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_SpecialbetOption'
CREATE TABLE [dbo].[GF_SpecialbetOption] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Odds] float  NOT NULL,
    [GF_SpecialBet_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Game'
CREATE TABLE [dbo].[GF_Game] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Finished] bit  NOT NULL,
    [TeamOneGuid] uniqueidentifier  NOT NULL,
    [TeamTwoGuid] uniqueidentifier  NOT NULL,
    [GoalsTeamOne] int  NOT NULL,
    [GoalsTeamTwo] int  NOT NULL,
    [Winner] int  NOT NULL,
    [OddsTeamOne] float  NOT NULL,
    [OddsDraw] float  NOT NULL,
    [OddsTeamTwo] float  NOT NULL,
    [StartDate] datetime  NOT NULL,
    [ProviderGameId] int  NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_ExternalTeam'
CREATE TABLE [dbo].[GF_ExternalTeam] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Flag] nvarchar(max)  NOT NULL,
    [Guid] uniqueidentifier  NOT NULL,
    [ProviderTitle] nvarchar(max)  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_Placedbet'
CREATE TABLE [dbo].[GF_Placedbet] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Loginname] nvarchar(max)  NOT NULL,
    [Calculated] bit  NOT NULL,
    [Winner] int  NOT NULL,
    [Amount] float  NOT NULL,
    [Odds] float  NOT NULL,
    [GF_SpecialBet_Id] int  NOT NULL,
    [GF_Game_Id] int  NOT NULL
);
GO

-- Creating table 'GF_TournamentUser'
CREATE TABLE [dbo].[GF_TournamentUser] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [UserId] nvarchar(max)  NOT NULL,
    [Balance] float  NOT NULL,
    [AvgWins] float  NOT NULL,
    [AvgBets] float  NOT NULL,
    [AvgOdds] float  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL,
    [Principal_PrincipalID] int  NOT NULL
);
GO

-- Creating table 'GF_InteralTeam'
CREATE TABLE [dbo].[GF_InteralTeam] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [Logo] nvarchar(max)  NULL,
    [Guid] nvarchar(max)  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL
);
GO

-- Creating table 'GF_QuizAction'
CREATE TABLE [dbo].[GF_QuizAction] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Action] nvarchar(max)  NOT NULL,
    [GF_Quiz_Id] int  NOT NULL,
    [GF_Achievement_Id] int  NOT NULL
);
GO

-- Creating table 'GF_TournamentAction'
CREATE TABLE [dbo].[GF_TournamentAction] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Action] nvarchar(max)  NOT NULL,
    [GF_Tournament_Id] int  NOT NULL,
    [GF_Achievement_Id] int  NOT NULL
);
GO

-- Creating table 'GF_BetHistory'
CREATE TABLE [dbo].[GF_BetHistory] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Date] datetime  NOT NULL,
    [Balance] float  NOT NULL,
    [AmountWon] float  NOT NULL,
    [Title] nvarchar(max)  NOT NULL,
    [GF_TournamentUser_Id] int  NOT NULL
);
GO




-- Creating primary key on [Id] in table 'GF_Achievement'
ALTER TABLE [dbo].[GF_Achievement]
ADD CONSTRAINT [PK_GF_Achievement]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_AssignedAchievement'
ALTER TABLE [dbo].[GF_AssignedAchievement]
ADD CONSTRAINT [PK_GF_AssignedAchievement]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Accolade'
ALTER TABLE [dbo].[GF_Accolade]
ADD CONSTRAINT [PK_GF_Accolade]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_SkillLevel'
ALTER TABLE [dbo].[GF_SkillLevel]
ADD CONSTRAINT [PK_GF_SkillLevel]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Quiz'
ALTER TABLE [dbo].[GF_Quiz]
ADD CONSTRAINT [PK_GF_Quiz]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Field'
ALTER TABLE [dbo].[GF_Field]
ADD CONSTRAINT [PK_GF_Field]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Option'
ALTER TABLE [dbo].[GF_Option]
ADD CONSTRAINT [PK_GF_Option]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [PK_GF_Response]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_ResponseField'
ALTER TABLE [dbo].[GF_ResponseField]
ADD CONSTRAINT [PK_GF_ResponseField]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_QuizUser'
ALTER TABLE [dbo].[GF_QuizUser]
ADD CONSTRAINT [PK_GF_QuizUser]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Tournament'
ALTER TABLE [dbo].[GF_Tournament]
ADD CONSTRAINT [PK_GF_Tournament]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_TournamentMember'
ALTER TABLE [dbo].[GF_TournamentMember]
ADD CONSTRAINT [PK_GF_TournamentMember]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_SpecialBet'
ALTER TABLE [dbo].[GF_SpecialBet]
ADD CONSTRAINT [PK_GF_SpecialBet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_SpecialbetOption'
ALTER TABLE [dbo].[GF_SpecialbetOption]
ADD CONSTRAINT [PK_GF_SpecialbetOption]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Game'
ALTER TABLE [dbo].[GF_Game]
ADD CONSTRAINT [PK_GF_Game]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_ExternalTeam'
ALTER TABLE [dbo].[GF_ExternalTeam]
ADD CONSTRAINT [PK_GF_ExternalTeam]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_Placedbet'
ALTER TABLE [dbo].[GF_Placedbet]
ADD CONSTRAINT [PK_GF_Placedbet]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_TournamentUser'
ALTER TABLE [dbo].[GF_TournamentUser]
ADD CONSTRAINT [PK_GF_TournamentUser]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_InteralTeam'
ALTER TABLE [dbo].[GF_InteralTeam]
ADD CONSTRAINT [PK_GF_InteralTeam]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_QuizAction'
ALTER TABLE [dbo].[GF_QuizAction]
ADD CONSTRAINT [PK_GF_QuizAction]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_TournamentAction'
ALTER TABLE [dbo].[GF_TournamentAction]
ADD CONSTRAINT [PK_GF_TournamentAction]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO

-- Creating primary key on [Id] in table 'GF_BetHistory'
ALTER TABLE [dbo].[GF_BetHistory]
ADD CONSTRAINT [PK_GF_BetHistory]
    PRIMARY KEY CLUSTERED ([Id] ASC);
GO



-- Creating foreign key on [Author_PrincipalID] in table 'GF_Accolade'
ALTER TABLE [dbo].[GF_Accolade]
ADD CONSTRAINT [FK_PrincipalGF_Accolade]
    FOREIGN KEY ([Author_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_Accolade'
CREATE INDEX [IX_FK_PrincipalGF_Accolade]
ON [dbo].[GF_Accolade]
    ([Author_PrincipalID]);
GO

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_AssignedAchievement'
ALTER TABLE [dbo].[GF_AssignedAchievement]
ADD CONSTRAINT [FK_PrincipalGF_AssignedAchievement]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_AssignedAchievement'
CREATE INDEX [IX_FK_PrincipalGF_AssignedAchievement]
ON [dbo].[GF_AssignedAchievement]
    ([Principal_PrincipalID]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_Field'
ALTER TABLE [dbo].[GF_Field]
ADD CONSTRAINT [FK_GF_QuizGF_Field]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_Field'
CREATE INDEX [IX_FK_GF_QuizGF_Field]
ON [dbo].[GF_Field]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [GF_Field_Id] in table 'GF_Option'
ALTER TABLE [dbo].[GF_Option]
ADD CONSTRAINT [FK_GF_FieldGF_Option]
    FOREIGN KEY ([GF_Field_Id])
    REFERENCES [dbo].[GF_Field]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_FieldGF_Option'
CREATE INDEX [IX_FK_GF_FieldGF_Option]
ON [dbo].[GF_Option]
    ([GF_Field_Id]);
GO

-- Creating foreign key on [GF_Response_Id] in table 'GF_ResponseField'
ALTER TABLE [dbo].[GF_ResponseField]
ADD CONSTRAINT [FK_GF_ResponseGF_ResponseField]
    FOREIGN KEY ([GF_Response_Id])
    REFERENCES [dbo].[GF_Response]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_ResponseGF_ResponseField'
CREATE INDEX [IX_FK_GF_ResponseGF_ResponseField]
ON [dbo].[GF_ResponseField]
    ([GF_Response_Id]);
GO

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [FK_PrincipalGF_Response]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_Response'
CREATE INDEX [IX_FK_PrincipalGF_Response]
ON [dbo].[GF_Response]
    ([Principal_PrincipalID]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_TournamentMember'
ALTER TABLE [dbo].[GF_TournamentMember]
ADD CONSTRAINT [FK_GF_TournamentGF_TournamentMember]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_TournamentMember'
CREATE INDEX [IX_FK_GF_TournamentGF_TournamentMember]
ON [dbo].[GF_TournamentMember]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_SpecialBet'
ALTER TABLE [dbo].[GF_SpecialBet]
ADD CONSTRAINT [FK_GF_TournamentGF_SpecialBet]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_SpecialBet'
CREATE INDEX [IX_FK_GF_TournamentGF_SpecialBet]
ON [dbo].[GF_SpecialBet]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_SpecialBet_Id] in table 'GF_SpecialbetOption'
ALTER TABLE [dbo].[GF_SpecialbetOption]
ADD CONSTRAINT [FK_GF_SpecialBetGF_SpecialbetOption]
    FOREIGN KEY ([GF_SpecialBet_Id])
    REFERENCES [dbo].[GF_SpecialBet]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_SpecialBetGF_SpecialbetOption'
CREATE INDEX [IX_FK_GF_SpecialBetGF_SpecialbetOption]
ON [dbo].[GF_SpecialbetOption]
    ([GF_SpecialBet_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_Game'
ALTER TABLE [dbo].[GF_Game]
ADD CONSTRAINT [FK_GF_TournamentGF_Game]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_Game'
CREATE INDEX [IX_FK_GF_TournamentGF_Game]
ON [dbo].[GF_Game]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_TournamentUser'
ALTER TABLE [dbo].[GF_TournamentUser]
ADD CONSTRAINT [FK_GF_TournamentGF_TournamentUser]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_TournamentUser'
CREATE INDEX [IX_FK_GF_TournamentGF_TournamentUser]
ON [dbo].[GF_TournamentUser]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_QuizUser'
ALTER TABLE [dbo].[GF_QuizUser]
ADD CONSTRAINT [FK_GF_QuizGF_QuizAdmin]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_QuizAdmin'
CREATE INDEX [IX_FK_GF_QuizGF_QuizAdmin]
ON [dbo].[GF_QuizUser]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_QuizAction'
ALTER TABLE [dbo].[GF_QuizAction]
ADD CONSTRAINT [FK_GF_QuizGF_QuizAction]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_QuizAction'
CREATE INDEX [IX_FK_GF_QuizGF_QuizAction]
ON [dbo].[GF_QuizAction]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [GF_Achievement_Id] in table 'GF_QuizAction'
ALTER TABLE [dbo].[GF_QuizAction]
ADD CONSTRAINT [FK_GF_AchievementGF_QuizAction]
    FOREIGN KEY ([GF_Achievement_Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AchievementGF_QuizAction'
CREATE INDEX [IX_FK_GF_AchievementGF_QuizAction]
ON [dbo].[GF_QuizAction]
    ([GF_Achievement_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_TournamentAction'
ALTER TABLE [dbo].[GF_TournamentAction]
ADD CONSTRAINT [FK_GF_TournamentGF_TournamentAction]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_TournamentAction'
CREATE INDEX [IX_FK_GF_TournamentGF_TournamentAction]
ON [dbo].[GF_TournamentAction]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Achievement_Id] in table 'GF_TournamentAction'
ALTER TABLE [dbo].[GF_TournamentAction]
ADD CONSTRAINT [FK_GF_AchievementGF_TournamentAction]
    FOREIGN KEY ([GF_Achievement_Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AchievementGF_TournamentAction'
CREATE INDEX [IX_FK_GF_AchievementGF_TournamentAction]
ON [dbo].[GF_TournamentAction]
    ([GF_Achievement_Id]);
GO

-- Creating foreign key on [GF_Quiz_Id] in table 'GF_Response'
ALTER TABLE [dbo].[GF_Response]
ADD CONSTRAINT [FK_GF_QuizGF_Response]
    FOREIGN KEY ([GF_Quiz_Id])
    REFERENCES [dbo].[GF_Quiz]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_QuizGF_Response'
CREATE INDEX [IX_FK_GF_QuizGF_Response]
ON [dbo].[GF_Response]
    ([GF_Quiz_Id]);
GO

-- Creating foreign key on [Principal_PrincipalID] in table 'GF_TournamentUser'
ALTER TABLE [dbo].[GF_TournamentUser]
ADD CONSTRAINT [FK_GF_TournamentUserPrincipal]
    FOREIGN KEY ([Principal_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentUserPrincipal'
CREATE INDEX [IX_FK_GF_TournamentUserPrincipal]
ON [dbo].[GF_TournamentUser]
    ([Principal_PrincipalID]);
GO

-- Creating foreign key on [GF_TournamentUser_Id] in table 'GF_BetHistory'
ALTER TABLE [dbo].[GF_BetHistory]
ADD CONSTRAINT [FK_GF_TournamentUserGF_BetHisory]
    FOREIGN KEY ([GF_TournamentUser_Id])
    REFERENCES [dbo].[GF_TournamentUser]
        ([Id])
    ON DELETE CASCADE ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentUserGF_BetHisory'
CREATE INDEX [IX_FK_GF_TournamentUserGF_BetHisory]
ON [dbo].[GF_BetHistory]
    ([GF_TournamentUser_Id]);
GO

-- Creating foreign key on [GF_Achievement_Id] in table 'GF_SkillLevel'
ALTER TABLE [dbo].[GF_SkillLevel]
ADD CONSTRAINT [FK_GF_AchievementGF_SkillLevel]
    FOREIGN KEY ([GF_Achievement_Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AchievementGF_SkillLevel'
CREATE INDEX [IX_FK_GF_AchievementGF_SkillLevel]
ON [dbo].[GF_SkillLevel]
    ([GF_Achievement_Id]);
GO

-- Creating foreign key on [GF_Achievement_Id] in table 'GF_AssignedAchievement'
ALTER TABLE [dbo].[GF_AssignedAchievement]
ADD CONSTRAINT [FK_GF_AchievementGF_AssignedAchievement]
    FOREIGN KEY ([GF_Achievement_Id])
    REFERENCES [dbo].[GF_Achievement]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_AchievementGF_AssignedAchievement'
CREATE INDEX [IX_FK_GF_AchievementGF_AssignedAchievement]
ON [dbo].[GF_AssignedAchievement]
    ([GF_Achievement_Id]);
GO

-- Creating foreign key on [GF_SkillLevel_Id] in table 'GF_AssignedAchievement'
ALTER TABLE [dbo].[GF_AssignedAchievement]
ADD CONSTRAINT [FK_GF_SkillLevelGF_AssignedAchievement]
    FOREIGN KEY ([GF_SkillLevel_Id])
    REFERENCES [dbo].[GF_SkillLevel]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_SkillLevelGF_AssignedAchievement'
CREATE INDEX [IX_FK_GF_SkillLevelGF_AssignedAchievement]
ON [dbo].[GF_AssignedAchievement]
    ([GF_SkillLevel_Id]);
GO

-- Creating foreign key on [Reciever_PrincipalID] in table 'GF_Accolade'
ALTER TABLE [dbo].[GF_Accolade]
ADD CONSTRAINT [FK_PrincipalGF_Accolade1]
    FOREIGN KEY ([Reciever_PrincipalID])
    REFERENCES [dbo].[Principal]
        ([PrincipalID])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_PrincipalGF_Accolade1'
CREATE INDEX [IX_FK_PrincipalGF_Accolade1]
ON [dbo].[GF_Accolade]
    ([Reciever_PrincipalID]);
GO

-- Creating foreign key on [GF_SpecialBet_Id] in table 'GF_Placedbet'
ALTER TABLE [dbo].[GF_Placedbet]
ADD CONSTRAINT [FK_GF_SpecialBetGF_Placedbet]
    FOREIGN KEY ([GF_SpecialBet_Id])
    REFERENCES [dbo].[GF_SpecialBet]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_SpecialBetGF_Placedbet'
CREATE INDEX [IX_FK_GF_SpecialBetGF_Placedbet]
ON [dbo].[GF_Placedbet]
    ([GF_SpecialBet_Id]);
GO

-- Creating foreign key on [GF_Game_Id] in table 'GF_Placedbet'
ALTER TABLE [dbo].[GF_Placedbet]
ADD CONSTRAINT [FK_GF_GameGF_Placedbet]
    FOREIGN KEY ([GF_Game_Id])
    REFERENCES [dbo].[GF_Game]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_GameGF_Placedbet'
CREATE INDEX [IX_FK_GF_GameGF_Placedbet]
ON [dbo].[GF_Placedbet]
    ([GF_Game_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_ExternalTeam'
ALTER TABLE [dbo].[GF_ExternalTeam]
ADD CONSTRAINT [FK_GF_TournamentGF_ExternalTeam]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_ExternalTeam'
CREATE INDEX [IX_FK_GF_TournamentGF_ExternalTeam]
ON [dbo].[GF_ExternalTeam]
    ([GF_Tournament_Id]);
GO

-- Creating foreign key on [GF_Tournament_Id] in table 'GF_InteralTeam'
ALTER TABLE [dbo].[GF_InteralTeam]
ADD CONSTRAINT [FK_GF_TournamentGF_InteralTeam]
    FOREIGN KEY ([GF_Tournament_Id])
    REFERENCES [dbo].[GF_Tournament]
        ([Id])
    ON DELETE NO ACTION ON UPDATE NO ACTION;
GO

-- Creating non-clustered index for FOREIGN KEY 'FK_GF_TournamentGF_InteralTeam'
CREATE INDEX [IX_FK_GF_TournamentGF_InteralTeam]
ON [dbo].[GF_InteralTeam]
    ([GF_Tournament_Id]);
GO








